/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.Phaser;
import java.util.concurrent.TimeUnit;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Timeout(value=60L)
public class SplitParallelTimeoutNoAggregationStrategyTest
extends ContextTestSupport {
    private final Phaser phaser = new Phaser(3);

    @BeforeEach
    void sendEarly() {
        Assumptions.assumeTrue((boolean)this.context.isStarted(), (String)"The test cannot be run because the context is not started");
        this.template.sendBody("direct:start", (Object)"A,B,C");
    }

    @Test
    public void testSplitTimeout() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)mock.message(0).body()).not(SplitParallelTimeoutNoAggregationStrategyTest.body().contains((Object)"A"));
        this.phaser.awaitAdvanceInterruptibly(0, 5000L, TimeUnit.SECONDS);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").split((Expression)this.body().tokenize(",")).parallelProcessing().timeout(100L).choice().when(this.body().isEqualTo((Object)"A")).to("direct:a")).when(this.body().isEqualTo((Object)"B")).to("direct:b")).when(this.body().isEqualTo((Object)"C")).to("direct:c")).end().end().to("mock:result");
                ((RouteDefinition)this.from("direct:a").process(e -> SplitParallelTimeoutNoAggregationStrategyTest.this.phaser.arriveAndAwaitAdvance())).delay(200L).setBody((Expression)this.constant("A"));
                ((RouteDefinition)this.from("direct:b").process(e -> SplitParallelTimeoutNoAggregationStrategyTest.this.phaser.arriveAndAwaitAdvance())).setBody((Expression)this.constant("B"));
                ((RouteDefinition)this.from("direct:c").process(e -> SplitParallelTimeoutNoAggregationStrategyTest.this.phaser.arriveAndAwaitAdvance())).delay(10L).setBody((Expression)this.constant("C"));
            }
        };
    }
}

