/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.ThreadPoolBuilder;
import org.apache.camel.util.concurrent.ThreadPoolRejectedPolicy;
import org.awaitility.Awaitility;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.api.parallel.Isolated;

@Isolated
@Timeout(value=30L)
public class SplitParallelThreadPoolAbortTest
extends ContextTestSupport {
    @Test
    public void testSplitParallel() throws Exception {
        AtomicInteger ok = new AtomicInteger();
        AtomicInteger fail = new AtomicInteger();
        Runnable r = () -> {
            try {
                this.template.sendBody("direct:start", List.of(List.of("0-0", "0-1"), List.of("1-0", "1-1")));
                ok.incrementAndGet();
            }
            catch (Exception e) {
                fail.incrementAndGet();
            }
        };
        ExecutorService pool = Executors.newFixedThreadPool(10);
        for (int i = 0; i < 10; ++i) {
            pool.submit(r);
        }
        Awaitility.await().untilAsserted(() -> Assertions.assertEquals((int)10, (int)fail.get(), (String)"All should fail"));
        this.log.info("Errors: {}", (Object)fail.get());
        this.log.info("OK: {}", (Object)ok.get());
    }

    @Override
    protected RoutesBuilder createRouteBuilder() throws Exception {
        return new RouteBuilder(){

            public void configure() throws Exception {
                ExecutorService executorService = new ThreadPoolBuilder(this.getContext()).poolSize(1).maxPoolSize(1).maxQueueSize(0).rejectedPolicy(ThreadPoolRejectedPolicy.Abort).build("inner");
                this.from("direct:start").split((Expression)this.body()).parallelProcessing().to("direct:inner?synchronous=true");
                this.from("direct:inner").split((Expression)this.body()).executorService(executorService).log("${body}");
            }
        };
    }
}

