/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitParallelSynchronousTest
extends ContextTestSupport {
    private String before;
    private String middle;
    private String after;

    @Test
    public void testSynchronous() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:end");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:a", (Object)"A,B,C,D,E");
        this.assertMockEndpointsSatisfied();
        Assertions.assertNotEquals((Object)this.before, (Object)this.middle);
        Assertions.assertNotEquals((Object)this.after, (Object)this.middle);
        Assertions.assertEquals((Object)this.before, (Object)this.after);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((RouteDefinition)this.from("direct:a").process(e -> {
                    SplitParallelSynchronousTest.this.before = Thread.currentThread().getName();
                })).split((Expression)this.body().tokenize(",")).parallelProcessing().synchronous().process(e -> {
                    SplitParallelSynchronousTest.this.middle = Thread.currentThread().getName();
                })).end().process(e -> {
                    SplitParallelSynchronousTest.this.after = Thread.currentThread().getName();
                }).to("mock:end");
            }
        };
    }
}

