/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Iterator;
import java.util.function.Consumer;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SplitIteratorNullTest
extends ContextTestSupport {
    private final MyIterator myIterator = new MyIterator();

    @Test
    public void testSplitIteratorNull() throws Exception {
        Assertions.assertFalse((boolean)this.myIterator.isNullReturned());
        this.getMockEndpoint("mock:line").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        Assertions.assertTrue((boolean)this.myIterator.isNullReturned());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)this.constant(SplitIteratorNullTest.this.myIterator)).to("mock:line");
            }
        };
    }

    private static class MyIterator
    implements Iterator<String> {
        private int count = 4;
        private boolean nullReturned;

        private MyIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.count > 0;
        }

        @Override
        public String next() {
            --this.count;
            if (this.count == 0) {
                this.nullReturned = true;
                return null;
            }
            if (this.count == 1) {
                return "C";
            }
            if (this.count == 2) {
                return "B";
            }
            return "A";
        }

        public boolean isNullReturned() {
            return this.nullReturned;
        }

        @Override
        public void remove() {
        }

        @Override
        public void forEachRemaining(Consumer<? super String> action) {
        }
    }
}

