/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class SplitGroupSkipFirstTest
extends ContextTestSupport {
    @Test
    public void testSplitSkipFirst() throws Exception {
        this.getMockEndpoint("mock:group").expectedBodiesReceived(new Object[]{"ABC\nDEF\nGHI", "JKL\nMN"});
        this.template.sendBody("direct:start", (Object)"##comment\nABC\nDEF\nGHI\nJKL\nMN");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSplitSkipFirstOnlyHeader() throws Exception {
        this.getMockEndpoint("mock:group").expectedBodiesReceived(new Object[]{""});
        this.template.sendBody("direct:start", (Object)"##comment\n");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((SplitDefinition)this.from("direct:start").split().tokenize("\n", 3, true)).streaming().to("mock:group");
            }
        };
    }
}

