/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.model.SplitDefinition;
import org.junit.jupiter.api.Test;

public class SplitGroupMultiXmlTest
extends ContextTestSupport {
    @Test
    public void testTokenXMLPairGroup() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:split");
        mock.expectedMessageCount(3);
        ((MockValueBuilder)mock.message(0).body()).isEqualTo((Object)"<order id=\"1\" xmlns=\"http:acme.com\">Camel in Action</order><order id=\"2\" xmlns=\"http:acme.com\">ActiveMQ in Action</order>");
        ((MockValueBuilder)mock.message(1).body()).isEqualTo((Object)"<order id=\"3\" xmlns=\"http:acme.com\">Spring in Action</order><order id=\"4\" xmlns=\"http:acme.com\">Scala in Action</order>");
        ((MockValueBuilder)mock.message(2).body()).isEqualTo((Object)"<order id=\"5\" xmlns=\"http:acme.com\">Groovy in Action</order>");
        String body = this.createBody();
        this.template.sendBodyAndHeader(this.fileUri(), (Object)body, "CamelFileName", (Object)"orders.xml");
        this.assertMockEndpointsSatisfied();
    }

    protected String createBody() {
        StringBuilder sb = new StringBuilder("<?xml version=\"1.0\"?>\n");
        sb.append("<orders xmlns=\"http:acme.com\">\n");
        sb.append("  <order id=\"1\">Camel in Action</order>\n");
        sb.append("  <order id=\"2\">ActiveMQ in Action</order>\n");
        sb.append("  <order id=\"3\">Spring in Action</order>\n");
        sb.append("  <order id=\"4\">Scala in Action</order>\n");
        sb.append("  <order id=\"5\">Groovy in Action</order>\n");
        sb.append("</orders>");
        return sb.toString();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)((SplitDefinition)this.from(SplitGroupMultiXmlTest.this.fileUri("?initialDelay=0&delay=10")).split().tokenizeXML("order", "orders", 2)).to("log:split")).to("mock:split");
            }
        };
    }
}

