/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Test;

public class SplitCustomExpressionTest
extends ContextTestSupport {
    @Test
    public void testSplitCustomExpression() throws Exception {
        this.getMockEndpoint("mock:split").expectedBodiesReceived(new Object[]{"A", "B", "C"});
        this.template.sendBody("direct:start", (Object)"A,B,C");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").split((Expression)new MyCustomExpression()).to("mock:split");
            }
        };
    }

    public static class MyCustomExpression
    implements Expression {
        public <T> T evaluate(Exchange exchange, Class<T> type) {
            String body = (String)exchange.getIn().getBody(String.class);
            String[] parts = body.split(",");
            List<String> list = List.of(parts);
            return (T)list.iterator();
        }
    }
}

