/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.AggregationStrategy;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ExpressionNode;
import org.apache.camel.spi.Registry;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SplitAggregateInOutTest
extends ContextTestSupport {
    private static final Logger LOG = LoggerFactory.getLogger(SplitAggregateInOutTest.class);
    private final String expectedBody = "Response[(id=1,item=A);(id=2,item=B);(id=3,item=C)]";

    @Test
    public void testSplitAndAggregateInOut() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Response[(id=1,item=A);(id=2,item=B);(id=3,item=C)]"});
        Object out = this.template.requestBody("direct:start", (Object)"A@B@C");
        Assertions.assertEquals((Object)"Response[(id=1,item=A);(id=2,item=B);(id=3,item=C)]", (Object)out);
        LOG.debug("Response to caller: {}", out);
        this.assertMockEndpointsSatisfied();
    }

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("MyOrderService", (Object)new MyOrderService());
        return jndi;
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ExpressionNode)this.from("direct:start").split((Expression)this.body().tokenize("@"), (AggregationStrategy)new MyOrderStrategy()).to("bean:MyOrderService?method=handleOrder")).end().to("bean:MyOrderService?method=buildCombinedResponse").to("mock:result");
            }
        };
    }

    public static class MyOrderService {
        private static int counter;

        public String handleOrder(String line) {
            LOG.debug("HandleOrder: {}", (Object)line);
            return "(id=" + ++counter + ",item=" + line + ")";
        }

        public String buildCombinedResponse(String line) {
            LOG.debug("BuildCombinedResponse: {}", (Object)line);
            return "Response[" + line + "]";
        }
    }

    public static class MyOrderStrategy
    implements AggregationStrategy {
        public Exchange aggregate(Exchange oldExchange, Exchange newExchange) {
            if (oldExchange == null) {
                return newExchange;
            }
            Object orders = (String)oldExchange.getIn().getBody(String.class);
            String newLine = (String)newExchange.getIn().getBody(String.class);
            LOG.debug("Aggregate old orders: {}", orders);
            LOG.debug("Aggregate new order: {}", (Object)newLine);
            orders = (String)orders + ";" + newLine;
            oldExchange.getIn().setBody(orders);
            return oldExchange;
        }
    }
}

