/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Comparator;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ObjectHelper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SortExpressionTest
extends ContextTestSupport {
    @Test
    public void testSortBody() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hadrian,William,Claus");
        this.assertMockEndpointsSatisfied();
        List list = (List)((Exchange)mock.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertEquals((Object)"Claus", list.get(0));
        Assertions.assertEquals((Object)"Hadrian", list.get(1));
        Assertions.assertEquals((Object)"William", list.get(2));
    }

    @Test
    public void testSortReverse() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:reverse", (Object)"Hadrian,William,Claus");
        this.assertMockEndpointsSatisfied();
        List list = (List)((Exchange)mock.getExchanges().get(0)).getIn().getBody(List.class);
        Assertions.assertEquals((Object)"William", list.get(0));
        Assertions.assertEquals((Object)"Hadrian", list.get(1));
        Assertions.assertEquals((Object)"Claus", list.get(2));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").sort((Expression)this.body().tokenize(","))).to("mock:result");
                ((RouteDefinition)this.from("direct:reverse").sort((Expression)this.body().tokenize(","), (Comparator)new MyReverseComparator())).to("mock:result");
            }
        };
    }

    public static class MyReverseComparator
    implements Comparator<Object> {
        @Override
        public int compare(Object o1, Object o2) {
            return ObjectHelper.compare((Object)o1, (Object)o2) * -1;
        }
    }
}

