/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.TryDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleTryThrowExceptionFinallyTest
extends ContextTestSupport {
    @Test
    public void testSimpleTryThrowExceptionFinally() throws Exception {
        this.getMockEndpoint("mock:try").expectedMessageCount(1);
        this.getMockEndpoint("mock:finally").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        try {
            this.template.sendBody("direct:start", (Object)"Hello World");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Damn", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((TryDefinition)((TryDefinition)((TryDefinition)this.from("direct:start").doTry().to("mock:try")).throwException((Exception)new IllegalArgumentException("Damn"))).doFinally().to("mock:finally")).end().to("mock:result");
            }
        };
    }
}

