/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleSingleOutputMockTest
extends ContextTestSupport {
    @Test
    public void testSimple() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        Exchange out = this.template.request("direct:start", e -> e.getMessage().setBody((Object)"Hello World"));
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)ExchangePattern.InOut, (Object)out.getPattern());
        Assertions.assertTrue((boolean)out.hasOut());
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("mock:result");
            }
        };
    }
}

