/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.SendDefinition;
import org.apache.camel.spi.IdAware;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleProcessorIdAwareTest
extends ContextTestSupport {
    @Test
    public void testIdAware() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        List matches = this.context.getRoute("foo").filter("b*");
        Assertions.assertEquals((int)2, (int)matches.size());
        Processor bar = (Processor)matches.get(0);
        Processor baz = (Processor)matches.get(1);
        Assertions.assertEquals((Object)"bar", (Object)((IdAware)bar).getId());
        Assertions.assertEquals((Object)"baz", (Object)((IdAware)baz).getId());
        bar = this.context.getProcessor("bar");
        Assertions.assertNotNull((Object)bar);
        baz = this.context.getProcessor("baz");
        Assertions.assertNotNull((Object)baz);
        Processor unknown = this.context.getProcessor("unknown");
        Assertions.assertNull((Object)unknown);
        Processor result = this.context.getProcessor("result");
        Assertions.assertNotNull((Object)result);
        ProcessorDefinition def = this.context.getProcessorDefinition("result");
        Assertions.assertNotNull((Object)def);
        Assertions.assertEquals((Object)"result", (Object)def.getId());
        SendDefinition send = SimpleProcessorIdAwareTest.assertIsInstanceOf(SendDefinition.class, def);
        Assertions.assertNotNull((Object)send);
        Assertions.assertEquals((Object)"mock:result", (Object)send.getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").routeId("foo").choice().when((Predicate)this.header("bar")).to("log:bar")).id("bar")).otherwise().to("mock:result")).id("result")).end().to("log:baz").id("baz");
            }
        };
    }
}

