/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SimpleMockTwoRoutesTest
extends ContextTestSupport {
    @Test
    public void testSimple() throws Exception {
        Assertions.assertEquals((int)2, (int)this.context.getRoutesSize());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSimpleTwoMessages() throws Exception {
        Assertions.assertEquals((int)2, (int)this.context.getRoutesSize());
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("foo").to("log:foo")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"foo", (Object)exchange.getUnitOfWork().getRoute().getRouteId());
                    }
                })).to("mock:foo")).to("direct:bar")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"foo", (Object)exchange.getUnitOfWork().getRoute().getRouteId());
                    }
                })).to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").routeId("bar").to("log:bar")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"bar", (Object)exchange.getUnitOfWork().getRoute().getRouteId());
                    }
                })).to("mock:bar");
            }
        };
    }
}

