/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SimpleMockSampleTest
extends ContextTestSupport {
    @Test
    public void testSimpleThousandMessages() throws Exception {
        int count = 1000;
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(count);
        for (int i = 0; i < count; ++i) {
            this.template.sendBody("direct:start", (Object)"Hello World");
        }
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSimpleTwoMessages() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World", "Bye World"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("log:foo")).to("log:bar")).to("mock:result");
            }
        };
    }
}

