/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.camel.Component;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Endpoint;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRoute;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.file.FileConsumer;
import org.apache.camel.component.file.FileEndpoint;
import org.apache.camel.component.file.GenericFileOperations;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ShutdownDeferTest
extends ContextTestSupport {
    private static final AtomicBoolean CONSUMER_SUSPENDED = new AtomicBoolean();

    @Test
    public void testShutdownDeferred() throws Exception {
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.template.sendBody("seda:foo", (Object)"A");
        this.template.sendBody("seda:foo", (Object)"B");
        this.template.sendBody("seda:foo", (Object)"C");
        this.template.sendBody("seda:foo", (Object)"D");
        this.template.sendBody("seda:foo", (Object)"E");
        this.assertMockEndpointsSatisfied();
        Thread.sleep(50L);
        this.context.stop();
        Assertions.assertFalse((boolean)CONSUMER_SUSPENDED.get(), (String)"Should not have been suspended");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("seda:foo").startupOrder(1).to(ShutdownDeferTest.this.fileUri());
                MyDeferFileEndpoint defer = new MyDeferFileEndpoint(ShutdownDeferTest.this.fileUri("?initialDelay=0&delay=10"), this.getContext().getComponent("file"));
                defer.setFile(ShutdownDeferTest.this.testDirectory().toFile());
                this.from((Endpoint)defer).startupOrder(2).shutdownRoute(ShutdownRoute.Defer).to("mock:bar");
            }
        };
    }

    private static final class MyDeferFileEndpoint
    extends FileEndpoint {
        private MyDeferFileEndpoint(String endpointUri, Component component) {
            super(endpointUri, component);
        }

        protected FileConsumer newFileConsumer(Processor processor, GenericFileOperations<File> operations) {
            return new FileConsumer(this, processor, operations, this.createGenericFileStrategy()){

                protected void doSuspend() throws Exception {
                    CONSUMER_SUSPENDED.set(true);
                    super.doSuspend();
                }
            };
        }
    }
}

