/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledOnOs;

@DisabledOnOs(architectures={"s390x"}, disabledReason="This test does not run reliably on s390x (see CAMEL-21438)")
public class ShutdownCompleteCurrentTaskOnlyTest
extends ContextTestSupport {
    public static final String FILE_QUERY = "?initialDelay=0&delay=10&synchronous=true";

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        String url = this.fileUri(FILE_QUERY);
        this.template.sendBodyAndHeader(url, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(url, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(url, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(url, (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader(url, (Object)"E", "CamelFileName", (Object)"e.txt");
    }

    @Test
    public void testShutdownCompleteCurrentTaskOnly() throws Exception {
        this.context.getShutdownStrategy().setTimeout(20L);
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        this.context.stop();
        Assertions.assertTrue((bar.getReceivedCounter() < 5 ? 1 : 0) != 0, (String)("Should NOT complete all messages, was: " + bar.getReceivedCounter()));
    }

    protected RouteBuilder createRouteBuilder() {
        final String url = this.fileUri(FILE_QUERY);
        return new RouteBuilder(){

            public void configure() {
                this.from(url).shutdownRunningTask(ShutdownRunningTask.CompleteCurrentTaskOnly).delay(1000L).syncDelayed().to("seda:foo");
                this.from("seda:foo").routeId("route2").to("mock:bar");
            }
        };
    }
}

