/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.ShutdownRunningTask;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class ShutdownCompleteAllTasksTest
extends ContextTestSupport {
    public static final String FILE_URI_QUERY = "?initialDelay=0&delay=10&synchronous=true";
    private final AtomicInteger counter = new AtomicInteger();
    private final CountDownLatch latch = new CountDownLatch(2);

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        String url = this.fileUri(FILE_URI_QUERY);
        this.template.sendBodyAndHeader(url, (Object)"A", "CamelFileName", (Object)"a.txt");
        this.template.sendBodyAndHeader(url, (Object)"B", "CamelFileName", (Object)"b.txt");
        this.template.sendBodyAndHeader(url, (Object)"C", "CamelFileName", (Object)"c.txt");
        this.template.sendBodyAndHeader(url, (Object)"D", "CamelFileName", (Object)"d.txt");
        this.template.sendBodyAndHeader(url, (Object)"E", "CamelFileName", (Object)"e.txt");
    }

    @Test
    public void testShutdownCompleteAllTasks() throws Exception {
        this.context.getShutdownStrategy().setTimeout(30L);
        this.context.getRouteController().startRoute("foo");
        MockEndpoint bar = this.getMockEndpoint("mock:bar");
        bar.expectedMinimumMessageCount(1);
        this.assertMockEndpointsSatisfied();
        int batch = (Integer)((Exchange)bar.getReceivedExchanges().get(0)).getProperty("CamelBatchSize", Integer.TYPE);
        this.latch.await(10L, TimeUnit.SECONDS);
        this.context.stop();
        Assertions.assertEquals((int)batch, (int)this.counter.get(), (String)"Should complete all messages");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from(ShutdownCompleteAllTasksTest.this.fileUri(ShutdownCompleteAllTasksTest.FILE_URI_QUERY)).routeId("foo").autoStartup(false).shutdownRunningTask(ShutdownRunningTask.CompleteAllTasks).process((Processor)new MyProcessor())).to("mock:bar");
            }
        };
    }

    public class MyProcessor
    implements Processor {
        public void process(Exchange exchange) {
            ShutdownCompleteAllTasksTest.this.counter.incrementAndGet();
            ShutdownCompleteAllTasksTest.this.latch.countDown();
        }
    }
}

