/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SetRouteVariableTest
extends ContextTestSupport {
    private MockEndpoint end;
    private final String variableName = "foo";
    private final String expectedVariableValue = "bar";
    private final String expectedVariableValue2 = "bar2";

    @Test
    public void testSetExchangeVariableMidRoute() throws Exception {
        Assertions.assertNull((Object)this.context.getVariable("route:myRoute:foo"));
        Assertions.assertNull((Object)this.context.getVariable("route:myRoute2:foo"));
        this.end.expectedMessageCount(2);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.template.sendBody("direct:start2", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.end.getExchanges();
        Exchange exchange = (Exchange)exchanges.get(0);
        String actualVariableValue = (String)exchange.getVariable("route:foo", String.class);
        Assertions.assertNull((Object)actualVariableValue);
        exchange = (Exchange)exchanges.get(1);
        actualVariableValue = (String)exchange.getVariable("route:foo", String.class);
        Assertions.assertNull((Object)actualVariableValue);
        Assertions.assertEquals((Object)"bar", (Object)this.context.getVariable("route:myRoute:foo"));
        Assertions.assertEquals((Object)"bar2", (Object)this.context.getVariable("route:myRoute2:foo"));
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").routeId("myRoute").setVariable("route:foo").constant((Object)"bar")).to("mock:end");
                ((ProcessorDefinition)this.from("direct:start2").routeId("myRoute2").setVariable("route:foo").constant((Object)"bar2")).to("mock:end");
            }
        };
    }
}

