/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ProcessorDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SetPropertyTest
extends ContextTestSupport {
    private MockEndpoint end;
    private final String propertyName = "foo";
    private final String expectedPropertyValue = "bar";

    @Test
    public void testSetExchangePropertyMidRoute() throws Exception {
        this.end.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"<blah/>");
        this.assertMockEndpointsSatisfied();
        List exchanges = this.end.getExchanges();
        Exchange exchange = (Exchange)exchanges.get(0);
        String actualPropertyValue = (String)exchange.getProperty("foo", String.class);
        Assertions.assertEquals((Object)"bar", (Object)actualPropertyValue);
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.end = this.getMockEndpoint("mock:end");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setProperty("foo").constant((Object)"bar")).to("mock:end");
            }
        };
    }
}

