/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.language.constant.ConstantLanguage;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SetHeadersProcessorTest
extends ContextTestSupport {
    private final Map<String, Expression> headerMap = new LinkedHashMap<String, Expression>();
    protected final String body = "<person name='Jane' age='10'/>";
    protected MockEndpoint expected;

    @Test
    public void testUseConstantParameters() throws Exception {
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)"ABC");
        ((MockValueBuilder)this.expected.message(0).header("bar")).isEqualTo((Object)"XYZ");
        this.template.sendBodyAndHeader("direct:startConstant", (Object)"<person name='Jane' age='10'/>", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseSimpleLanguage() throws Exception {
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)"ABC");
        ((MockValueBuilder)this.expected.message(0).header("bar")).isEqualTo((Object)"XYZ");
        this.template.sendBodyAndHeader("direct:start", (Object)"ABC", "bar1", (Object)"XYZ");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseXpathLanguage() throws Exception {
        ((MockValueBuilder)this.expected.message(0).header("name")).isEqualTo((Object)"Jane");
        ((MockValueBuilder)this.expected.message(0).header("age")).isEqualTo((Object)10);
        this.template.sendBody("direct:startXpath", (Object)"<person name='Jane' age='10'/>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseMap() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:startMap").setHeaders(new Object[]{SetHeadersProcessorTest.this.headerMap})).to("mock:result");
            }
        });
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)"ABC");
        ((MockValueBuilder)this.expected.message(0).header("bar")).isEqualTo((Object)"XYZ");
        this.template.sendBody("direct:startMap", (Object)"<person name='Jane' age='10'/>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseMapOf() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:startMap").setHeaders(new Object[]{Map.of("foo", "ABC", "bar", "XYZ")})).to("mock:result");
            }
        });
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)"ABC");
        ((MockValueBuilder)this.expected.message(0).header("bar")).isEqualTo((Object)"XYZ");
        this.template.sendBody("direct:startMap", (Object)"<person name='Jane' age='10'/>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseMethod() throws Exception {
        String hdrInBody = "foo,ABC,bar,XYZ";
        this.template.sendBody("direct:startMethod", (Object)hdrInBody);
        this.expected.getExchanges().get(0);
        ((MockValueBuilder)this.expected.message(0).header("mapTest")).isEqualTo(new HeaderBean().getHeaders(hdrInBody));
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetOneHeaderFromAnother() throws Exception {
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)15);
        ((MockValueBuilder)this.expected.message(0).header("bar")).isEqualTo((Object)true);
        this.template.sendBody("direct:startDepHeader", (Object)15);
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeaders(new Object[]{"foo", this.simple("${body}"), "bar", this.simple("${header.bar1}")})).to("mock:result");
                ((RouteDefinition)this.from("direct:startDepHeader").setHeaders(new Object[]{"foo", this.simple("${body}"), "bar", this.simple("${header.foo} > 10", Boolean.class)})).to("mock:result");
                ((RouteDefinition)this.from("direct:startConstant").setHeaders(new Object[]{"foo", this.constant("ABC"), "bar", this.constant("XYZ")})).to("mock:result");
                ((RouteDefinition)this.from("direct:startXpath").setHeaders(new Object[]{"age", this.xpath("/person/@age"), "name", this.xpath("/person/@name")})).to("mock:result");
                ((RouteDefinition)this.from("direct:startMethod").setHeaders(new Object[]{"mapTest", this.method(HeaderBean.class, "getHeaders")})).to("mock:result");
            }
        };
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.headerMap.put("foo", ConstantLanguage.constant((Object)"ABC"));
        this.headerMap.put("bar", ConstantLanguage.constant((Object)"XYZ"));
        this.expected = this.getMockEndpoint("mock:result");
    }

    public static class HeaderBean {
        final Map<String, String> map = new LinkedHashMap<String, String>();

        Map<String, String> getHeaders(String body) {
            this.map.clear();
            String[] mapInfo = body.split(",");
            for (int i = 0; i < mapInfo.length; i += 2) {
                this.map.put(mapInfo[i], mapInfo[i + 1]);
            }
            return this.map;
        }
    }
}

