/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.ExpressionAdapter;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class SetHeaderUsingDslExpressionsTest
extends ContextTestSupport {
    protected final String body = "<person name='James' city='London'/>";
    protected MockEndpoint expected;

    @Test
    public void testUseConstant() throws Exception {
        MyValueClass value = new MyValueClass("value1", "value2");
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                MyValueClass insteadValue = new MyValueClass("value1", "value2");
                ((ProcessorDefinition)((ProcessorDefinition)this.from("direct:start").setHeader("foo").constant((Object)"ABC")).setHeader("value").constant((Object)insteadValue)).to("mock:result");
            }
        });
        ((MockValueBuilder)this.expected.message(0).header("value")).isEqualTo((Object)value);
        this.template.sendBodyAndHeader("direct:start", (Object)"<person name='James' city='London'/>", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseConstantParameter() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").setHeader("foo", (Expression)this.constant("ABC"))).to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)"<person name='James' city='London'/>", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").expression((Expression)new ExpressionAdapter(){

                    public Object evaluate(Exchange exchange) {
                        return "ABC";
                    }
                })).to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)"<person name='James' city='London'/>", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseHeaderExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").header("bar")).to("mock:result");
            }
        });
        this.template.sendBodyAndHeader("direct:start", (Object)"<person name='James' city='London'/>", "bar", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseHeaderXpathExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").xpath("/personFile/text()")).to("mock:result");
            }
        });
        this.template.sendBody("direct:start", (Object)"<personFile>ABC</personFile>");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseBodyExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").body()).to("mock:result");
            }
        });
        this.template.sendBody("direct:start", (Object)"ABC");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUseBodyAsTypeExpression() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((ProcessorDefinition)this.from("direct:start").setHeader("foo").body(String.class)).to("mock:result");
            }
        });
        this.template.sendBody("direct:start", (Object)"ABC".getBytes());
        this.assertMockEndpointsSatisfied();
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.expected = this.getMockEndpoint("mock:result");
        ((MockValueBuilder)this.expected.message(0).header("foo")).isEqualTo((Object)"ABC");
    }

    public static final class MyValueClass {
        private final String value1;
        private final String value2;

        public MyValueClass(String v1, String v2) {
            this.value1 = v1;
            this.value2 = v2;
        }

        public int hashCode() {
            return this.value1.hashCode() * 10 + this.value2.hashCode();
        }

        public boolean equals(Object obj) {
            boolean result = false;
            if (obj instanceof MyValueClass) {
                MyValueClass value = (MyValueClass)obj;
                if (this.value1.equals(value.value1) && this.value2.equals(value.value2)) {
                    result = true;
                }
            }
            return result;
        }
    }
}

