/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SetExchangePatternTest
extends ContextTestSupport {
    @Test
    public void testInOut() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testInOut", ExchangePattern.InOut);
    }

    @Test
    public void testInOnly() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testInOnly", ExchangePattern.InOnly);
    }

    @Test
    public void testSetToInOnlyThenTo() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetToInOnlyThenTo", ExchangePattern.InOnly);
    }

    @Test
    public void testSetToInOutThenTo() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetToInOutThenTo", ExchangePattern.InOut);
    }

    @Test
    public void testToWithInOnlyParam() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testToWithInOnlyParam", ExchangePattern.InOnly);
    }

    @Test
    public void testToWithInOutParam() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testToWithInOutParam", ExchangePattern.InOut);
    }

    @Test
    public void testSetExchangePatternInOnly() throws Exception {
        this.assertMessageReceivedWithPattern("direct:testSetExchangePatternInOnly", ExchangePattern.InOnly);
    }

    @Test
    public void testSetAsString() throws Exception {
        this.assertMessageReceivedWithPattern("direct:asString", ExchangePattern.InOut);
    }

    @Test
    public void testPreserveOldMEPInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        Exchange out = this.template.send("direct:testInOut", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOnly);
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)ExchangePattern.InOnly, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testPreserveOldMEPInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        Exchange out = this.template.send("direct:testInOnly", new Processor(){

            public void process(Exchange exchange) {
                exchange.getIn().setBody((Object)"Hello World");
                exchange.setPattern(ExchangePattern.InOut);
            }
        });
        Assertions.assertNotNull((Object)out);
        Assertions.assertEquals((Object)ExchangePattern.InOut, (Object)out.getPattern());
        this.assertMockEndpointsSatisfied();
    }

    protected void assertMessageReceivedWithPattern(String sendUri, ExchangePattern expectedPattern) throws InterruptedException {
        ExchangePattern sendPattern = switch (expectedPattern) {
            case ExchangePattern.InOut -> ExchangePattern.InOnly;
            case ExchangePattern.InOnly -> ExchangePattern.InOut;
            default -> ExchangePattern.InOnly;
        };
        MockEndpoint resultEndpoint = this.getMockEndpoint("mock:result");
        String expectedBody = "InOnlyMessage";
        resultEndpoint.expectedBodiesReceived(new Object[]{expectedBody});
        resultEndpoint.expectedHeaderReceived("foo", (Object)"bar");
        this.template.sendBodyAndHeader(sendUri, sendPattern, (Object)expectedBody, "foo", (Object)"bar");
        resultEndpoint.assertIsSatisfied();
        ExchangePattern actualPattern = ((Exchange)resultEndpoint.getExchanges().get(0)).getPattern();
        Assertions.assertEquals((Object)actualPattern, (Object)expectedPattern, (String)"received exchange pattern");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:testInOut").to(ExchangePattern.InOut, "mock:result");
                this.from("direct:testInOnly").to(ExchangePattern.InOnly, "mock:result");
                ((RouteDefinition)this.from("direct:testSetToInOnlyThenTo").setExchangePattern(ExchangePattern.InOnly)).to("mock:result");
                ((RouteDefinition)this.from("direct:testSetToInOutThenTo").setExchangePattern(ExchangePattern.InOut)).to("mock:result");
                this.from("direct:testToWithInOnlyParam").to(ExchangePattern.InOnly, "mock:result");
                this.from("direct:testToWithInOutParam").to(ExchangePattern.InOut, "mock:result");
                ((RouteDefinition)this.from("direct:testSetExchangePatternInOnly").setExchangePattern(ExchangePattern.InOnly)).to("mock:result");
                ((RouteDefinition)this.from("direct:asString").setExchangePattern("InOut")).to("mock:result");
            }
        };
    }
}

