/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelContext;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Message;
import org.apache.camel.Predicate;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.DefaultMessage;
import org.junit.jupiter.api.Test;

public class SetBodyProcessorTest
extends ContextTestSupport {
    @Test
    public void testSetBody() throws Exception {
        MockEndpoint foo = this.getMockEndpoint("mock:foo");
        foo.expectedBodiesReceived(new Object[]{"World"});
        foo.expectedHeaderReceived("foo", (Object)123);
        foo.message(0).predicate(new Predicate(){

            public boolean matches(Exchange exchange) {
                return exchange.getIn() instanceof MyMessage;
            }
        });
        MockEndpoint result = this.getMockEndpoint("mock:result");
        result.expectedBodiesReceived(new Object[]{"Bye World"});
        result.expectedHeaderReceived("foo", (Object)123);
        result.message(0).predicate(new Predicate(){

            public boolean matches(Exchange exchange) {
                return !(exchange.getIn() instanceof MyMessage);
            }
        });
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                MyMessage my = new MyMessage(exchange.getContext());
                my.setBody("World");
                my.setHeader("foo", 123);
                exchange.setIn((Message)my);
            }
        });
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetBodyWithHeader() throws Exception {
        MockEndpoint result = this.getMockEndpoint("mock:test");
        result.expectedBodiesReceived(new Object[]{"bbb"});
        result.expectedHeaderReceived("text", (Object)"aab");
        this.template.sendBodyAndHeader("direct:start2", (Object)"aab", "text", (Object)"aab");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").to("mock:foo")).setBody((Expression)this.simple("Bye ${body}"))).to("mock:result");
                ((RouteDefinition)this.from("direct:start2").setBody((Expression)this.simple("${header.text.replace('a','b')}"))).to("mock:test");
            }
        };
    }

    private static class MyMessage
    extends DefaultMessage {
        public MyMessage(CamelContext camelContext) {
            super(camelContext);
        }

        public MyMessage newInstance() {
            return new MyMessage(this.getCamelContext());
        }
    }
}

