/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.ExchangePattern;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class SendExchangePatternOptionTest
extends ContextTestSupport {
    @Test
    public void testExchangePatternOptionInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.getMockEndpoint("mock:stub").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:stub").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testExchangePatternOptionInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:result").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOut);
        this.getMockEndpoint("mock:stub").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:stub").message(0).exchangePattern()).isEqualTo((Object)ExchangePattern.InOnly);
        this.template.requestBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").to("stub:foo?exchangePattern=InOnly")).to("mock:result");
                this.from("stub:foo").to("mock:stub");
            }
        };
    }
}

