/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SagaCompletionMode;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.InMemorySagaService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SagaTimeoutTest
extends ContextTestSupport {
    @Test
    public void testTimeoutCalledCorrectly() throws Exception {
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        compensate.expectedHeaderReceived("id", (Object)"myid");
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.template.sendBody("direct:saga", (Object)"Hello");
        end.assertIsSatisfied();
        compensate.assertIsSatisfied();
    }

    @Test
    public void testTimeoutHasNoEffectIfCompleted() throws Exception {
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        compensate.setResultWaitTime(500L);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedMessageCount(1);
        complete.expectedHeaderReceived("id", (Object)"myid");
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        this.template.sendBody("direct:saga-auto", (Object)"Hello");
        end.assertIsSatisfied();
        complete.assertIsSatisfied();
        compensate.assertIsNotSatisfied();
    }

    @Test
    public void testTimeoutMultiParticipants() throws Exception {
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedMessageCount(0);
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedMessageCount(1);
        CamelExecutionException ex = (CamelExecutionException)Assertions.assertThrows(CamelExecutionException.class, () -> this.template.sendBody("direct:saga-multi-participants", (Object)"Hello"));
        Assertions.assertEquals((Object)"Cannot begin: status is COMPENSATED", (Object)ex.getCause().getMessage());
        end.assertIsSatisfied();
        complete.assertIsSatisfied();
        compensate.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SagaTimeoutTest.this.context.addService((Object)new InMemorySagaService());
                this.from("direct:saga").saga().timeout(100L, TimeUnit.MILLISECONDS).option("id", (Expression)this.constant("myid")).completionMode(SagaCompletionMode.MANUAL).compensation("mock:compensate").to("mock:end");
                this.from("direct:saga-auto").saga().timeout(350L, TimeUnit.MILLISECONDS).option("id", (Expression)this.constant("myid")).compensation("mock:compensate").completion("mock:complete").to("mock:end");
                ((SagaDefinition)((RouteDefinition)this.from("direct:saga-multi-participants").process(exchange -> exchange.getMessage().setHeader("id", (Object)UUID.randomUUID().toString()))).saga().propagation(SagaPropagation.REQUIRES_NEW).to("direct:service1")).to("direct:service2");
                this.from("direct:service1").saga().option("id", (Expression)this.header("id")).propagation(SagaPropagation.MANDATORY).timeout(100L, TimeUnit.MILLISECONDS).compensation("mock:compensate").completion("mock:complete").delay(300L).to("mock:end");
                this.from("direct:service2").saga().option("id", (Expression)this.header("id")).propagation(SagaPropagation.MANDATORY).timeout(500L, TimeUnit.MILLISECONDS).compensation("mock:compensate").completion("mock:complete").to("mock:end");
            }
        };
    }
}

