/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Header;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.InMemorySagaService;
import org.awaitility.Awaitility;
import org.hamcrest.Matchers;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SagaTest
extends ContextTestSupport {
    private OrderManagerService orderManagerService;
    private CreditService creditService;

    @Test
    public void testCreditExhausted() {
        this.buy(20, false, false);
        this.buy(70, false, false);
        this.buy(20, false, true);
        this.buy(5, false, false);
        Awaitility.await().until(() -> this.orderManagerService.getOrders().size(), Matchers.equalTo((Object)3));
        Awaitility.await().until(() -> this.creditService.getCredit(), Matchers.equalTo((Object)5));
    }

    @Test
    public void testTotalCompensation() {
        for (int i = 0; i < 10; ++i) {
            if (i % 2 == 0) {
                this.buy(10, false, false);
                continue;
            }
            this.buy(10, true, true);
        }
        Awaitility.await().until(() -> this.orderManagerService.getOrders().size(), Matchers.equalTo((Object)5));
        Awaitility.await().until(() -> this.creditService.getCredit(), Matchers.equalTo((Object)50));
    }

    private void buy(int amount, boolean failAtTheEnd, boolean shouldFail) {
        block3: {
            try {
                this.context.createFluentProducerTemplate().to("direct:saga").withHeader("amount", (Object)amount).withHeader("fail", (Object)failAtTheEnd).request();
                if (shouldFail) {
                    Assertions.fail((String)"Exception not thrown");
                }
            }
            catch (Exception ex) {
                if (shouldFail) break block3;
                Assertions.fail((String)"Unexpected exception");
            }
        }
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SagaTest.this.orderManagerService = new OrderManagerService();
                SagaTest.this.creditService = new CreditService(100);
                InMemorySagaService sagaService = new InMemorySagaService();
                SagaTest.this.context.addService((Object)sagaService);
                ((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)((SagaDefinition)this.from("direct:saga").saga().propagation(SagaPropagation.REQUIRES_NEW).log("Creating a new order")).to("direct:newOrder")).log("Taking the credit")).to("direct:reserveCredit")).log("Finalizing")).to("direct:finalize")).log("Done!");
                ((SagaDefinition)((ProcessorDefinition)this.from("direct:newOrder").saga().propagation(SagaPropagation.MANDATORY).compensation("direct:cancelOrder").transform().header("Long-Running-Action")).bean((Object)SagaTest.this.orderManagerService, "newOrder")).log("Order ${body} created");
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:cancelOrder").transform().header("Long-Running-Action")).bean((Object)SagaTest.this.orderManagerService, "cancelOrder")).log("Order ${body} cancelled");
                ((SagaDefinition)((ProcessorDefinition)this.from("direct:reserveCredit").saga().propagation(SagaPropagation.MANDATORY).compensation("direct:refundCredit").transform().header("Long-Running-Action")).bean((Object)SagaTest.this.creditService, "reserveCredit")).log("Credit ${header.amount} reserved in action ${body}");
                ((RouteDefinition)((ProcessorDefinition)this.from("direct:refundCredit").transform().header("Long-Running-Action")).bean((Object)SagaTest.this.creditService, "refundCredit")).log("Credit for action ${body} refunded");
                ((ChoiceDefinition)this.from("direct:finalize").saga().propagation(SagaPropagation.NOT_SUPPORTED).choice().when(this.header("fail").isEqualTo((Object)true)).process(x -> {
                    throw new RuntimeException("fail");
                })).end();
            }
        };
    }

    public static class CreditService {
        private final int totalCredit;
        private final Map<String, Integer> reservations = new HashMap<String, Integer>();

        public CreditService(int totalCredit) {
            this.totalCredit = totalCredit;
        }

        public synchronized void reserveCredit(String id, @Header(value="amount") int amount) {
            int credit = this.getCredit();
            if (amount > credit) {
                throw new IllegalStateException("Insufficient credit");
            }
            this.reservations.put(id, amount);
        }

        public synchronized void refundCredit(String id) {
            this.reservations.remove(id);
        }

        public synchronized int getCredit() {
            return this.totalCredit - this.reservations.values().stream().reduce(0, (a, b) -> a + b);
        }
    }

    public static class OrderManagerService {
        private final Set<String> orders = new HashSet<String>();

        public synchronized void newOrder(String id) {
            this.orders.add(id);
        }

        public synchronized void cancelOrder(String id) {
            this.orders.remove(id);
        }

        public synchronized Set<String> getOrders() {
            return new TreeSet<String>(this.orders);
        }
    }
}

