/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.SagaDefinition;
import org.apache.camel.model.SagaPropagation;
import org.apache.camel.saga.InMemorySagaService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SagaPropagationTest
extends ContextTestSupport {
    private List<String> sagaIds;

    @Test
    public void testPropagationRequired() {
        this.context.createFluentProducerTemplate().to("direct:required").request();
        SagaPropagationTest.assertListSize(this.sagaIds, 3);
        this.assertUniqueNonNullSagaIds(1);
    }

    @Test
    public void testPropagationRequiresNew() {
        this.context.createFluentProducerTemplate().to("direct:requiresNew").request();
        SagaPropagationTest.assertListSize(this.sagaIds, 3);
        this.assertUniqueNonNullSagaIds(3);
    }

    @Test
    public void testPropagationNotSupported() {
        this.context.createFluentProducerTemplate().to("direct:notSupported").request();
        SagaPropagationTest.assertListSize(this.sagaIds, 4);
        this.assertNonNullSagaIds(1);
    }

    @Test
    public void testPropagationSupports() {
        this.context.createFluentProducerTemplate().to("direct:supports").request();
        SagaPropagationTest.assertListSize(this.sagaIds, 2);
        this.assertNonNullSagaIds(1);
    }

    @Test
    public void testPropagationMandatory() {
        try {
            this.context.createFluentProducerTemplate().to("direct:mandatory").request();
            Assertions.fail((String)"Exception not thrown");
        }
        catch (CamelExecutionException camelExecutionException) {
            // empty catch block
        }
    }

    @Test
    public void testPropagationNever() {
        try {
            this.context.createFluentProducerTemplate().to("direct:never").request();
            Assertions.fail((String)"Exception not thrown");
        }
        catch (CamelExecutionException camelExecutionException) {
            // empty catch block
        }
    }

    protected RouteBuilder createRouteBuilder() {
        this.sagaIds = new LinkedList<String>();
        return new RouteBuilder(){

            public void configure() throws Exception {
                InMemorySagaService sagaService = new InMemorySagaService();
                SagaPropagationTest.this.context.addService((Object)sagaService);
                ((SagaDefinition)this.from("direct:required").saga().process(SagaPropagationTest.this.addSagaIdToList())).to("direct:required2");
                ((SagaDefinition)this.from("direct:required2").saga().propagation(SagaPropagation.REQUIRED).process(SagaPropagationTest.this.addSagaIdToList())).to("direct:required3");
                this.from("direct:required3").saga().process(SagaPropagationTest.this.addSagaIdToList());
                ((SagaDefinition)((SagaDefinition)this.from("direct:requiresNew").saga().propagation(SagaPropagation.REQUIRES_NEW).process(SagaPropagationTest.this.addSagaIdToList())).to("direct:requiresNew2")).to("direct:requiresNew2");
                this.from("direct:requiresNew2").saga().propagation(SagaPropagation.REQUIRES_NEW).process(SagaPropagationTest.this.addSagaIdToList());
                ((RouteDefinition)((RouteDefinition)this.from("direct:notSupported").process(SagaPropagationTest.this.addSagaIdToList())).to("direct:notSupported2")).to("direct:notSupported3");
                ((SagaDefinition)this.from("direct:notSupported2").saga().process(SagaPropagationTest.this.addSagaIdToList())).to("direct:notSupported3");
                this.from("direct:notSupported3").saga().propagation(SagaPropagation.NOT_SUPPORTED).process(SagaPropagationTest.this.addSagaIdToList());
                ((RouteDefinition)this.from("direct:supports").to("direct:supports2")).to("direct:supports3");
                this.from("direct:supports2").saga().to("direct:supports3");
                this.from("direct:supports3").saga().propagation(SagaPropagation.SUPPORTS).process(SagaPropagationTest.this.addSagaIdToList());
                this.from("direct:mandatory").to("direct:mandatory2");
                this.from("direct:mandatory2").saga().propagation(SagaPropagation.MANDATORY).process(SagaPropagationTest.this.addSagaIdToList());
                this.from("direct:never").saga().to("direct:never2");
                this.from("direct:never2").saga().propagation(SagaPropagation.NEVER).process(SagaPropagationTest.this.addSagaIdToList());
            }
        };
    }

    private Processor addSagaIdToList() {
        return ex -> this.sagaIds.add((String)ex.getMessage().getHeader("Long-Running-Action", String.class));
    }

    private void assertUniqueNonNullSagaIds(int num) {
        Set uniqueNonNull = this.sagaIds.stream().filter(Objects::nonNull).collect(Collectors.toSet());
        if (uniqueNonNull.size() != num) {
            Assertions.fail((String)("Expeced size " + num + ", actual " + uniqueNonNull.size()));
        }
    }

    private void assertNonNullSagaIds(int num) {
        List<String> nonNull = this.sagaIds.stream().filter(Objects::nonNull).toList();
        if (nonNull.size() != num) {
            Assertions.fail((String)("Expeced size " + num + ", actual " + nonNull.size()));
        }
    }
}

