/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Predicate;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.saga.InMemorySagaService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SagaOptionsTest
extends ContextTestSupport {
    @Test
    public void testHeaderForwardedToComplete() throws Exception {
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedMessageCount(1);
        complete.expectedHeaderReceived("id", (Object)"myheader");
        complete.expectedHeaderReceived("name", (Object)"Nicola");
        complete.expectedMessagesMatches(new Predicate[]{ex -> ex.getIn().getHeader("Long-Running-Action") != null});
        this.template.sendBodyAndHeader("direct:workflow", (Object)"Hello", "myname", (Object)"Nicola");
        complete.assertIsSatisfied();
    }

    @Test
    public void testHeaderForwardedToCompensate() throws Exception {
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        compensate.expectedHeaderReceived("id", (Object)"myheader");
        compensate.expectedHeaderReceived("name", (Object)"Nicola");
        compensate.expectedMessagesMatches(new Predicate[]{ex -> ex.getIn().getHeader("Long-Running-Action") != null});
        try {
            this.template.sendBodyAndHeader("direct:workflow", (Object)"compensate", "myname", (Object)"Nicola");
            Assertions.fail((String)"Should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        compensate.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                SagaOptionsTest.this.context.addService((Object)new InMemorySagaService());
                ((ChoiceDefinition)this.from("direct:workflow").saga().option("id", (Expression)this.constant("myheader")).option("name", (Expression)this.header("myname")).completion("mock:complete").compensation("mock:compensate").choice().when(this.body().isEqualTo((Object)"compensate")).process(ex -> {
                    throw new RuntimeException("forced compensate");
                })).end().setHeader("myname", (Expression)this.constant("TryToOverride")).setHeader("name", (Expression)this.constant("TryToOverride")).to("mock:endpoint");
            }
        };
    }
}

