/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.saga.InMemorySagaService;
import org.junit.jupiter.api.Test;

public class SagaFailuresTest
extends ContextTestSupport {
    private AtomicInteger maxFailures;

    @Test
    public void testCompensationAfterFailures() throws Exception {
        this.maxFailures = new AtomicInteger(2);
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        this.sendBody("direct:saga-compensate", "hello");
        compensate.assertIsSatisfied();
    }

    @Test
    public void testNoCompensationAfterMaxFailures() throws Exception {
        this.maxFailures = new AtomicInteger(3);
        MockEndpoint compensate = this.getMockEndpoint("mock:compensate");
        compensate.expectedMessageCount(1);
        compensate.setResultWaitTime(200L);
        this.sendBody("direct:saga-compensate", "hello");
        compensate.assertIsNotSatisfied();
    }

    @Test
    public void testCompletionAfterFailures() throws Exception {
        this.maxFailures = new AtomicInteger(2);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedMessageCount(1);
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedBodiesReceived(new Object[]{"hello"});
        this.sendBody("direct:saga-complete", "hello");
        complete.assertIsSatisfied();
        end.assertIsSatisfied();
    }

    @Test
    public void testNoCompletionAfterMaxFailures() throws Exception {
        this.maxFailures = new AtomicInteger(3);
        MockEndpoint complete = this.getMockEndpoint("mock:complete");
        complete.expectedMessageCount(1);
        complete.setResultWaitTime(200L);
        MockEndpoint end = this.getMockEndpoint("mock:end");
        end.expectedBodiesReceived(new Object[]{"hello"});
        this.sendBody("direct:saga-complete", "hello");
        complete.assertIsNotSatisfied();
        end.assertIsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() throws Exception {
                InMemorySagaService sagaService = new InMemorySagaService();
                sagaService.setMaxRetryAttempts(3);
                sagaService.setRetryDelayInMilliseconds(20L);
                SagaFailuresTest.this.context.addService((Object)sagaService);
                this.from("direct:saga-compensate").saga().compensation("direct:compensate").process(x -> {
                    throw new RuntimeException("fail");
                });
                this.from("direct:saga-complete").saga().completion("direct:complete").to("mock:end");
                ((RouteDefinition)this.from("direct:compensate").process(x -> {
                    int current = SagaFailuresTest.this.maxFailures.decrementAndGet();
                    if (current >= 0) {
                        throw new RuntimeException("compensation failure");
                    }
                })).to("mock:compensate");
                ((RouteDefinition)this.from("direct:complete").process(x -> {
                    int current = SagaFailuresTest.this.maxFailures.decrementAndGet();
                    if (current >= 0) {
                        throw new RuntimeException("completion failure");
                    }
                })).to("mock:complete");
            }
        };
    }
}

