/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.CamelExecutionException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.ErrorHandlerFactory;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipRedeliverTest
extends ContextTestSupport {
    private static int counter;

    @Test
    public void testOk() throws Exception {
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,mock:b");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testThrowExceptionAtA() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,direct:a,mock:b");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    @Test
    public void testThrowExceptionAtB() throws Exception {
        counter = 0;
        this.getMockEndpoint("mock:a").expectedMessageCount(1);
        this.getMockEndpoint("mock:b").expectedMessageCount(1);
        this.getMockEndpoint("mock:c").expectedMessageCount(0);
        try {
            this.template.sendBodyAndHeader("direct:start", (Object)"Hello World", "mySlip", (Object)"mock:a,mock:b,direct:b,mock:c");
            Assertions.fail((String)"Should have thrown exception");
        }
        catch (CamelExecutionException e) {
            Assertions.assertEquals((Object)"Forced", (Object)e.getCause().getMessage());
        }
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)counter);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.errorHandler((ErrorHandlerFactory)this.defaultErrorHandler().maximumRedeliveries(3).redeliveryDelay(0L));
                this.from("direct:start").routingSlip((Expression)this.header("mySlip"));
                ((RouteDefinition)this.from("direct:a").to("log:a")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
                ((RouteDefinition)this.from("direct:b").to("log:b")).process(new Processor(){

                    public void process(Exchange exchange) {
                        Assertions.assertEquals((Object)"Hello World", (Object)exchange.getIn().getBody());
                        Assertions.assertFalse((boolean)exchange.hasOut(), (String)"Should not have OUT");
                        Assertions.assertNull((Object)exchange.getException());
                        exchange.getIn().setBody((Object)"Bye World");
                        ++counter;
                        throw new IllegalArgumentException("Forced");
                    }
                });
            }
        };
    }
}

