/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.processor.RoutingSlip;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipNoCacheTest
extends ContextTestSupport {
    @Test
    public void testNoCache() throws Exception {
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        this.sendBody("foo");
        this.sendBody("bar");
        List<Processor> list = this.getProcessors("foo");
        RoutingSlip rl = (RoutingSlip)list.get(0);
        Assertions.assertNotNull((Object)rl);
        Assertions.assertEquals((int)-1, (int)rl.getCacheSize());
        Assertions.assertEquals((int)1, (int)this.context.getEndpointRegistry().size());
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.sendBody("foo");
        this.sendBody("bar");
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)4, (int)this.context.getEndpointRegistry().size());
    }

    protected void sendBody(String body) {
        this.template.sendBodyAndHeader("direct:a", (Object)body, "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:a").routingSlip((Expression)this.header("recipientListHeader").tokenize(",")).cacheSize(-1).id("foo");
            }
        };
    }
}

