/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipInOutAndInOnlyTest
extends ContextTestSupport {
    private final String slip = "direct:a,direct:b,direct:c";

    @Test
    public void testRoutingSlipInOut() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"HelloABC"});
        String out = (String)this.template.requestBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)"direct:a,direct:b,direct:c", String.class);
        Assertions.assertEquals((Object)"HelloABC", (Object)out);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRoutingSlipInOnly() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"HelloABC"});
        this.template.sendBodyAndHeader("direct:start", (Object)"Hello", "slip", (Object)"direct:a,direct:b,direct:c");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routingSlip((Expression)this.header("slip")).to("mock:result");
                this.from("direct:a").transform((Expression)this.body().append((Object)"A"));
                this.from("direct:b").transform((Expression)this.body().append((Object)"B"));
                this.from("direct:c").transform((Expression)this.body().append((Object)"C"));
            }
        };
    }
}

