/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RoutingSlipDefinition;
import org.junit.jupiter.api.Test;

public class RoutingSlipDslTest
extends ContextTestSupport {
    @Test
    public void testRoutingSlipDsl() throws Exception {
        MockEndpoint x = this.getMockEndpoint("mock:x");
        MockEndpoint y = this.getMockEndpoint("mock:y");
        MockEndpoint z = this.getMockEndpoint("mock:z");
        x.expectedBodiesReceived(new Object[]{"foo", "bar"});
        y.expectedBodiesReceived(new Object[]{"foo", "bar"});
        z.expectedBodiesReceived(new Object[]{"foo", "bar"});
        this.template.sendBodyAndHeader("direct:a", (Object)"foo", "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
        this.template.sendBodyAndHeader("direct:a", (Object)"bar", "recipientListHeader", (Object)"mock:x,mock:y,mock:z");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RoutingSlipDefinition)this.from("direct:a").routingSlip().message(m -> ((String)m.getHeader("recipientListHeader", String.class)).split(","))).end();
            }
        };
    }
}

