/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.HashMap;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.Processor;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockValueBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutingSlipContextScopedOnExceptionIssueTest
extends ContextTestSupport {
    @Test
    public void testUsingInterceptor() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process(new Processor(){

                    public void process(Exchange exchange) {
                        String routeId = exchange.getUnitOfWork().getRoute().getRouteId();
                        Assertions.assertEquals((Object)"fail", (Object)routeId);
                    }
                })).to("mock:error");
                this.interceptSendToEndpoint("direct*").process(new Processor(){

                    public void process(Exchange exchange) {
                        String target = (String)exchange.getProperty("CamelInterceptedEndpoint", String.class);
                        exchange.getIn().setHeader("target", (Object)target);
                    }
                });
                this.from("direct:start").routeId("start").routingSlip((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:fail").routeId("fail").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).header("target")).isEqualTo((Object)"direct://fail");
        String foo = "direct:foo,direct:fail";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", foo);
        headers.put("CamelFileName", "hello.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testUsingExistingHeaders() throws Exception {
        this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).process(new Processor(){

                    public void process(Exchange exchange) {
                        String routeId = exchange.getUnitOfWork().getRoute().getRouteId();
                        Assertions.assertEquals((Object)"fail", (Object)routeId);
                    }
                })).to("mock:error");
                this.from("direct:start").routeId("start").routingSlip((Expression)this.header("foo"));
                ((RouteDefinition)this.from("direct:foo").routeId("foo").setBody((Expression)this.constant("Bye World"))).to("mock:foo");
                this.from("direct:fail").routeId("fail").throwException((Exception)new IllegalArgumentException("Forced"));
            }
        });
        this.context.start();
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:foo").message(0).exchangeProperty("CamelToEndpoint")).isEqualTo((Object)"mock://foo");
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        ((MockValueBuilder)this.getMockEndpoint("mock:error").message(0).exchangeProperty("CamelFailureEndpoint")).isEqualTo((Object)"direct://fail");
        String foo = "direct:foo,direct:fail";
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("foo", foo);
        headers.put("CamelFileName", "hello.txt");
        this.template.sendBodyAndHeaders("direct:start", (Object)"Hello World", headers);
        this.assertMockEndpointsSatisfied();
    }
}

