/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.OnCompletionDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.TransactedDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteTopLevelMisconfiguredTest
extends ContextTestSupport {
    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    public void testInvalidOnException() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((OnExceptionDefinition)this.from("direct:start").split((Expression)this.body()).onException(IllegalArgumentException.class).to("mock:illegal")).end().to("mock:split").end();
                }
            });
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }

    @Test
    public void testInvalidOnCompletion() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((OnCompletionDefinition)this.from("direct:start").split((Expression)this.body()).onCompletion().to("mock:done")).end().to("mock:split").end();
                }
            });
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }

    @Test
    public void testInvalidTransacted() throws Exception {
        try {
            this.context.addRoutes((RoutesBuilder)new RouteBuilder(){

                public void configure() {
                    ((TransactedDefinition)this.from("direct:start").split((Expression)this.body()).transacted().to("mock:split")).end();
                }
            });
            Assertions.fail((String)"Should fail");
        }
        catch (IllegalArgumentException e) {
            Assertions.assertTrue((boolean)e.getMessage().startsWith("The output must be added as top-level on the route."));
        }
    }
}

