/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RouteStopTest
extends ContextTestSupport {
    @Test
    public void testOtherwise() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:bye").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Other");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testHello() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(1);
        this.getMockEndpoint("mock:bye").expectedMessageCount(0);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testByeWithStop() throws Exception {
        this.getMockEndpoint("mock:hello").expectedMessageCount(0);
        this.getMockEndpoint("mock:bye").expectedMessageCount(1);
        this.getMockEndpoint("mock:other").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Bye World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testSetPropertyToStop() throws Exception {
        this.getMockEndpoint("mock:foo").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:foo", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").choice().when(this.body().contains((Object)"Hello")).to("mock:hello")).when(this.body().contains((Object)"Bye")).to("mock:bye")).stop()).otherwise().to("mock:other")).end().to("mock:result");
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").to("mock:foo")).process(e -> e.setRouteStop(true))).to("mock:result");
            }
        };
    }
}

