/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteStartupOrderTest
extends ContextTestSupport {
    @Test
    public void testRouteStartupOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getCamelContextExtension().getRouteStartupOrder();
        Assertions.assertEquals((int)4, (int)order.size());
        Assertions.assertEquals((Object)"seda://foo", (Object)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"seda://bar", (Object)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").startupOrder(2).to("seda:foo");
                this.from("seda:foo").startupOrder(1).to("mock:result");
                this.from("direct:bar").startupOrder(9).to("seda:bar");
                this.from("seda:bar").startupOrder(5).to("mock:other");
            }
        };
    }
}

