/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.spi.RouteStartupOrder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteStartupOrderSuspendResumeTest
extends ContextTestSupport {
    @Test
    public void testRouteStartupOrderSuspendResume() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        this.context.suspend();
        this.context.resume();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getCamelContextExtension().getRouteStartupOrder();
        Assertions.assertEquals((int)4, (int)order.size());
        Assertions.assertEquals((Object)"direct://foo", (Object)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://baz", (Object)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routeId("B").startupOrder(2).to("direct:foo");
                this.from("direct:foo").routeId("A").startupOrder(1).to("mock:result");
                this.from("direct:bar").routeId("D").startupOrder(9).to("direct:bar");
                this.from("direct:baz").routeId("C").startupOrder(5).to("mock:other");
            }
        };
    }
}

