/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.impl.DefaultCamelContext;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.RouteStartupOrder;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteServicesStartupOrderTest
extends ContextTestSupport {
    private static String startOrder = "";
    private final MyServiceBean service1 = new MyServiceBean("1");
    private final MyServiceBean service2 = new MyServiceBean("2");
    private final MyServiceBean service3 = new MyServiceBean("3");
    private final MyServiceBean service4 = new MyServiceBean("4");

    @Test
    public void testRouteServiceStartupOrder() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        DefaultCamelContext dcc = (DefaultCamelContext)this.context;
        List order = dcc.getCamelContextExtension().getRouteStartupOrder();
        Assertions.assertEquals((int)4, (int)order.size());
        Assertions.assertEquals((Object)"seda://foo", (Object)((RouteStartupOrder)order.get(0)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://start", (Object)((RouteStartupOrder)order.get(1)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"seda://bar", (Object)((RouteStartupOrder)order.get(2)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"direct://bar", (Object)((RouteStartupOrder)order.get(3)).getRoute().getEndpoint().getEndpointUri());
        Assertions.assertEquals((Object)"2143", (Object)startOrder);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").startupOrder(2).process((Processor)RouteServicesStartupOrderTest.this.service1)).to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").startupOrder(1).process((Processor)RouteServicesStartupOrderTest.this.service2)).to("mock:result");
                ((RouteDefinition)this.from("direct:bar").startupOrder(9).process((Processor)RouteServicesStartupOrderTest.this.service3)).to("seda:bar");
                ((RouteDefinition)this.from("seda:bar").startupOrder(5).process((Processor)RouteServicesStartupOrderTest.this.service4)).to("mock:other");
            }
        };
    }

    public static class MyServiceBean
    extends ServiceSupport
    implements Processor {
        private final String name;
        private boolean started;

        public MyServiceBean(String name) {
            this.name = name;
        }

        protected void doStart() {
            startOrder = startOrder + this.name;
            this.started = true;
        }

        protected void doStop() {
            this.started = false;
        }

        public boolean isStarted() {
            return this.started;
        }

        public String getName() {
            return this.name;
        }

        public void setStarted(boolean started) {
            this.started = started;
        }

        public void process(Exchange exchange) {
        }
    }
}

