/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class RoutePreconditionTest
extends ContextTestSupport {
    RoutePreconditionTest() {
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    void testRouteIncluded() throws Exception {
        Properties init = new Properties();
        init.setProperty("protocol", "json");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        RoutePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 2);
        RoutePreconditionTest.assertCollectionSize(this.context.getRoutes(), 2);
        Assertions.assertNotNull((Object)this.context.getRoute("myRoute"));
        Assertions.assertNotNull((Object)this.context.getRoute("myRouteNP"));
        this.getMockEndpoint("mock:out").expectedMessageCount(1);
        this.template.sendBody("direct:in", (Object)"Hello Included Route");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testRouteExcluded() throws Exception {
        Properties init = new Properties();
        init.setProperty("protocol", "avro");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        RoutePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RoutePreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        Assertions.assertNull((Object)this.context.getRoute("myRoute"));
        Assertions.assertNotNull((Object)this.context.getRoute("myRouteNP"));
    }

    @Test
    void testRouteIncludedByDefault() throws Exception {
        Properties init = new Properties();
        init.setProperty("protocol", "foo");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        RoutePreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RoutePreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        Assertions.assertNotNull((Object)this.context.getRoute("myRouteNP"));
        this.getMockEndpoint("mock:outNP").expectedMessageCount(1);
        this.template.sendBody("direct:inNP", (Object)"Hello Included Route");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:in").routeId("myRoute").precondition("'{{protocol}}' == 'json'").to("mock:out");
                this.from("direct:inNP").routeId("myRouteNP").to("mock:outNP");
            }
        };
    }
}

