/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.spi.Registry;
import org.apache.camel.support.RoutePolicySupport;
import org.junit.jupiter.api.Test;

public class RoutePoliciesRefTest
extends ContextTestSupport {
    private final MyCustomRoutePolicy policyA = new MyCustomRoutePolicy("A");
    private final MyCustomRoutePolicy policyB = new MyCustomRoutePolicy("B");

    @Override
    protected Registry createCamelRegistry() throws Exception {
        Registry jndi = super.createCamelRegistry();
        jndi.bind("policy-a", (Object)this.policyA);
        jndi.bind("policy-b", (Object)this.policyB);
        return jndi;
    }

    @Test
    public void testCustomPolicies() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedBodiesReceived(new Object[]{"Hello World"});
        mock.expectedHeaderReceived("A", (Object)"A");
        mock.expectedHeaderReceived("B", (Object)"B");
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").routePolicyRef("policy-a, policy-b").to("mock:result");
            }
        };
    }

    private static final class MyCustomRoutePolicy
    extends RoutePolicySupport {
        private final String name;

        private MyCustomRoutePolicy(String name) {
            this.name = name;
        }

        public void onExchangeBegin(Route route, Exchange exchange) {
            exchange.getIn().setHeader(this.name, (Object)this.name);
        }
    }
}

