/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.util.StopWatch;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RoutePerformanceCountTest
extends ContextTestSupport {
    private final CountProcessor processor = new CountProcessor();

    @Test
    public void testSendMessages() {
        StopWatch watch = new StopWatch();
        int size = 500;
        for (int i = 0; i < size; ++i) {
            String url = "direct:start";
            this.template.sendBody(url, (Object)("Message " + i));
        }
        Assertions.assertEquals((int)size, (int)this.processor.getCounter());
        long delta = watch.taken();
        this.log.info("RoutePerformanceCountTest: Sent: {} Took: {} ms", (Object)size, (Object)delta);
    }

    @Override
    protected boolean canRunOnThisPlatform() {
        String os = System.getProperty("os.name");
        return !os.toLowerCase(Locale.ENGLISH).contains("hp-ux");
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to(new String[]{"log:a?level=OFF", "log:b?level=OFF", "direct:c"});
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:c").choice().when().header("foo")).process((Processor)RoutePerformanceCountTest.this.processor)).otherwise().process((Processor)RoutePerformanceCountTest.this.processor)).end();
            }
        };
    }

    private static class CountProcessor
    implements Processor {
        private final AtomicInteger counter = new AtomicInteger();

        private CountProcessor() {
        }

        public void process(Exchange exchange) {
            this.counter.incrementAndGet();
        }

        public int getCounter() {
            return this.counter.intValue();
        }
    }
}

