/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Predicate;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.SendProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteNodePrefixIdTest
extends ContextTestSupport {
    @Test
    public void testRoutePrefixId() {
        Assertions.assertEquals((int)3, (int)this.context.getRoutes().size());
        SendProcessor send = (SendProcessor)this.context.getProcessor("aaamyFoo", SendProcessor.class);
        Assertions.assertNotNull((Object)send);
        send = (SendProcessor)this.context.getProcessor("bbbmyBar", SendProcessor.class);
        Assertions.assertNotNull((Object)send);
        send = (SendProcessor)this.context.getProcessor("cccmyCheese", SendProcessor.class);
        Assertions.assertNotNull((Object)send);
        Assertions.assertEquals((int)2, (int)this.context.getRoute("foo").filter("aaa*").size());
        Assertions.assertEquals((int)2, (int)this.context.getRoute("bar").filter("bbb*").size());
        Assertions.assertEquals((int)3, (int)((Route)this.context.getRoutes().get(2)).filter("ccc*").size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").nodePrefixId("aaa").to("mock:foo")).id("myFoo")).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").nodePrefixId("bbb").routeId("bar").to("mock:bar")).id("myBar")).to("seda:bar");
                ((ChoiceDefinition)((ChoiceDefinition)((ChoiceDefinition)this.from("direct:cheese").nodePrefixId("ccc").choice().when((Predicate)this.header("cheese")).to("mock:cheese")).id("myCheese")).otherwise().to("mock:gauda")).end();
            }
        };
    }
}

