/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.processor.SendProcessor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteNodePrefixIdDuplicateTest
extends ContextTestSupport {
    @Test
    public void testRoutePrefixId() {
        Assertions.assertEquals((int)2, (int)this.context.getRoutes().size());
        SendProcessor send = (SendProcessor)this.context.getProcessor("myMock", SendProcessor.class);
        Assertions.assertNull((Object)send);
        send = (SendProcessor)this.context.getProcessor("aaamyMock", SendProcessor.class);
        Assertions.assertNotNull((Object)send);
        send = (SendProcessor)this.context.getProcessor("bbbmyMock", SendProcessor.class);
        Assertions.assertNotNull((Object)send);
        Assertions.assertEquals((int)2, (int)this.context.getRoute("foo").filter("aaa*").size());
        Assertions.assertEquals((int)2, (int)this.context.getRoute("bar").filter("bbb*").size());
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:foo").routeId("foo").nodePrefixId("aaa").to("mock:foo")).id("myMock")).to("seda:foo");
                ((RouteDefinition)((RouteDefinition)this.from("direct:bar").nodePrefixId("bbb").routeId("bar").to("mock:bar")).id("myMock")).to("seda:bar");
            }
        };
    }
}

