/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Test;

public class RouteNoAutoStartupTest
extends ContextTestSupport {
    @Test
    public void testRouteNotAutoStarted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setAssertPeriod(50L);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    public void testRouteNotAutoStartedThenStarted() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(0);
        mock.setAssertPeriod(50L);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        mock.reset();
        mock.expectedMessageCount(1);
        this.context.getRouteController().startRoute("myRoute");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").to("seda:foo");
                ((RouteDefinition)this.from("seda:foo").autoStartup(false).id("myRoute")).to("mock:result");
            }
        };
    }
}

