/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.io.IOException;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.ChoiceDefinition;
import org.apache.camel.model.OnExceptionDefinition;
import org.apache.camel.model.RouteDefinition;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteIdTest
extends ContextTestSupport {
    @Test
    public void testRouteId() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(0);
        this.getMockEndpoint("mock:result").expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
        String id = ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId();
        Assertions.assertEquals((Object)"myCoolRoute", (Object)id);
    }

    @Test
    public void testRouteIdFailed() throws Exception {
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:result").expectedMessageCount(0);
        this.template.sendBody("direct:start", (Object)"Kaboom");
        this.assertMockEndpointsSatisfied();
        String id = ((RouteDefinition)this.context.getRouteDefinitions().get(0)).getId();
        Assertions.assertEquals((Object)"myCoolRoute", (Object)id);
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((OnExceptionDefinition)this.onException(Exception.class).handled(true).to("mock:error")).end();
                ((ChoiceDefinition)((ChoiceDefinition)this.from("direct:start").onException(IOException.class).redeliveryDelay(0L).maximumRedeliveries(5).end().routeId("myCoolRoute").choice().when(this.body().contains((Object)"Kaboom")).throwException((Exception)new IllegalArgumentException("Damn"))).otherwise().to("mock:result")).end();
            }
        };
    }
}

