/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.component.mock.MockEndpoint;
import org.junit.jupiter.api.Test;

public class RouteFormattedUriTest
extends ContextTestSupport {
    private final String name = "hello.txt";
    private final String pattern = ".*txt$";
    private final String result = "result";

    @Test
    public void testFormattedUri() throws Exception {
        MockEndpoint mock = this.getMockEndpoint("mock:result");
        mock.expectedMessageCount(1);
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        final String path = this.testDirectory().toString();
        return new RouteBuilder(){

            public void configure() {
                this.from("direct:start").toF("file://%s?fileName=%s", new Object[]{path, "hello.txt"});
                this.fromF("file://%s?include=%s", new Object[]{path, ".*txt$"}).toF("mock:%s", new Object[]{"result"});
            }
        };
    }
}

