/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.Properties;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Expression;
import org.apache.camel.RoutesBuilder;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.builder.RouteConfigurationBuilder;
import org.apache.camel.model.OnExceptionDefinition;
import org.junit.jupiter.api.Test;

class RouteConfigurationPreconditionTest
extends ContextTestSupport {
    RouteConfigurationPreconditionTest() {
    }

    @Override
    public boolean isUseRouteBuilder() {
        return false;
    }

    @Test
    void testRouteConfigurationIncluded() throws Exception {
        Properties init = new Properties();
        init.setProperty("activate", "true");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRouteConfigurationDefinitions(), 2);
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Activated"});
        this.template.sendBody("direct:start", (Object)"Hello Activated Route Config");
        this.assertMockEndpointsSatisfied();
    }

    @Test
    void testRouteConfigurationExcluded() throws Exception {
        Properties init = new Properties();
        init.setProperty("activate", "false");
        this.context.getPropertiesComponent().setInitialProperties(init);
        this.context.addRoutes((RoutesBuilder)this.createRouteBuilder());
        this.context.start();
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRouteConfigurationDefinitions(), 1);
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRouteDefinitions(), 1);
        RouteConfigurationPreconditionTest.assertCollectionSize(this.context.getRoutes(), 1);
        this.getMockEndpoint("mock:error").expectedMessageCount(1);
        this.getMockEndpoint("mock:error").expectedBodiesReceived(new Object[]{"Default"});
        this.template.sendBody("direct:start", (Object)"Hello Not Activated Route Config");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteConfigurationBuilder(){

            public void configuration() {
                this.from("direct:start").throwException((Exception)new IllegalArgumentException("Foo"));
                ((OnExceptionDefinition)this.routeConfiguration().precondition("{{activate}}").onException(IllegalArgumentException.class).handled(true).transform((Expression)this.constant("Activated"))).to("mock:error");
                ((OnExceptionDefinition)this.routeConfiguration().onException(Exception.class).handled(true).transform((Expression)this.constant("Default"))).to("mock:error");
            }
        };
    }
}

