/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import java.util.ArrayList;
import java.util.List;
import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.spi.Synchronization;
import org.apache.camel.spi.SynchronizationRouteAware;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class RouteAwareSynchronizationTest
extends ContextTestSupport {
    private static final List<String> EVENTS = new ArrayList<String>();

    @Test
    public void testRouteAwareSynchronization() throws Exception {
        EVENTS.clear();
        Assertions.assertEquals((int)0, (int)EVENTS.size());
        this.getMockEndpoint("mock:a").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:foo").expectedBodiesReceived(new Object[]{"Hello World"});
        this.getMockEndpoint("mock:b").expectedBodiesReceived(new Object[]{"Hello World"});
        this.template.send("direct:start", new Processor(){

            public void process(Exchange exchange) {
                exchange.getExchangeExtension().addOnCompletion((Synchronization)new MyRouteAware());
                exchange.getIn().setBody((Object)"Hello World");
            }
        });
        this.assertMockEndpointsSatisfied();
        Assertions.assertEquals((int)5, (int)EVENTS.size());
        Assertions.assertEquals((Object)"onBeforeRoute-start", (Object)EVENTS.get(0));
        Assertions.assertEquals((Object)"onBeforeRoute-foo", (Object)EVENTS.get(1));
        Assertions.assertEquals((Object)"onAfterRoute-foo", (Object)EVENTS.get(2));
        Assertions.assertEquals((Object)"onAfterRoute-start", (Object)EVENTS.get(3));
        Assertions.assertEquals((Object)"onComplete", (Object)EVENTS.get(4));
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)((RouteDefinition)this.from("direct:start").routeId("start").to("mock:a")).to("direct:foo")).to("mock:b");
                this.from("direct:foo").routeId("foo").to("mock:foo");
            }
        };
    }

    private static final class MyRouteAware
    implements Synchronization {
        private MyRouteAware() {
        }

        public void onComplete(Exchange exchange) {
            EVENTS.add("onComplete");
        }

        public void onFailure(Exchange exchange) {
            EVENTS.add("onFailure");
        }

        public SynchronizationRouteAware getRouteSynchronization() {
            return new SynchronizationRouteAware(){

                public void onBeforeRoute(Route route, Exchange exchange) {
                    EVENTS.add("onBeforeRoute-" + route.getId());
                }

                public void onAfterRoute(Route route, Exchange exchange) {
                    EVENTS.add("onAfterRoute-" + route.getId());
                }
            };
        }
    }
}

