/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.processor;

import org.apache.camel.ContextTestSupport;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.Route;
import org.apache.camel.RouteAware;
import org.apache.camel.builder.RouteBuilder;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.support.service.ServiceSupport;
import org.junit.jupiter.api.Test;

public class RouteAwareRouteTest
extends ContextTestSupport {
    @Test
    public void testRouteAware() throws Exception {
        this.getMockEndpoint("mock:result").expectedBodiesReceived(new Object[]{"foo"});
        this.template.sendBody("direct:start", (Object)"Hello World");
        this.assertMockEndpointsSatisfied();
    }

    protected RouteBuilder createRouteBuilder() {
        return new RouteBuilder(){

            public void configure() {
                ((RouteDefinition)this.from("direct:start").routeId("foo").process((Processor)new MyProcessor())).to("mock:result");
            }
        };
    }

    private static final class MyProcessor
    extends ServiceSupport
    implements Processor,
    RouteAware {
        private Route route;

        private MyProcessor() {
        }

        public void process(Exchange exchange) {
            exchange.getIn().setBody((Object)this.route.getId());
        }

        public void setRoute(Route route) {
            this.route = route;
        }

        public Route getRoute() {
            return this.route;
        }
    }
}

